﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var currPatPWID = 0,
    currMID,
    currPWEventID = 0,
    currIntakeID,
    currStatus,
    currEventModuleID,
    bInstrumentReadOnly = true,
    arrOriginalResponses = [],
    arrNewResponses = [];

var originalNoteTitle = '';
var originalNoteText = '';

var strCurrentModuleName = '',
    nCurrentInstrument = 1,
    nCurrentTreeNodeIndex = -1,
    nNewTreeNodeIndex = 0,
    nCurrentPathwayIndex = 0,
    nNewPathwayIndex = 0,
    bShowAddEvent = false,
    strContinueChange = ""; /*used to continue UI normal flow after async prompt is answer*/

//update the note hash after saving the form
function fnUpdateNoteHash() {
    originalNoteTitle = App.tfEventNoteTitle.getValue();
    originalNoteText = App.tfEventNote.getValue();
}

// ----------------------------------------------------------------------------------------
// Begin Region - IE8 Support
// --------------------------------------------------------------------------------------
if (typeof Array.prototype.forEach != 'function') {
    Array.prototype.forEach = function (callback) {
        for (var i = 0; i < this.length; i++) {
            callback.apply(this, [this[i], i, this]);
        }
    };
}
// ----------------------------------------------------------------------------------------
// End Region - IE8 Support
// --------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// Begin Region - Action Events
// ----------------------------------------------------------------------------------------

    var fnSubmitInstrument = function () {
        if (question.validateQuestionnaire()) {
            if (CheckForPossibleISE()) {
                ShowISEWarning();
                //if (!App.winISE.isVisible()) {
                //    App.winISE.show();
                //}
            } else {
                setTimeout(function () {
                    scrollTopInstrumentForm();
                }, 1);
                App.direct.INSTRUMENTS.AddInstrumentResponses(App.dfAssessmentDate.getValue(), App.tfAssessmentTime.getValue(), { success: fnSuccessAddResponses, failure: fnFailureAddResponses });
            }
        }
        else {
            scrollInstrumentToWarning();
        }
    };

    var scrollTopInstrumentForm = function () {
        //scroll the questionnaire container to the top
        ['pnlInstrumentEdit', 'pnlInstrumentReport'].forEach(function (pnlID) {
            $('div[id*="' + pnlID + '"]').each(function () {
                if (typeof (this.scrollTop) !== "undefined") {
                    this.scrollTop = 0;
                }
            });
        });
    };

    var TxTreeSelectedNode = function (rec, index) {
        if (nCurrentTreeNodeIndex == nNewTreeNodeIndex) { return false; }

        nCurrentTreeNodeIndex = index;
        strCurrentModuleName = rec.raw.text;
        
        //init encounter controls
        currPatPWID = rec.raw.pat_pw_id;
        currPWEventID = rec.raw.pat_pw_event_id;

        App.direct.PATSUMMARY.InitEncounter(rec.raw.pat_pw_id, rec.raw.pat_pw_event_id, {
            success: function ()
            {
                //update the hashes since we are moving to a new event
                ucPlanJS.original.planText = App.tfPLAN.getValue();
                ucPlanJS.original.planHash = ucPlanJS.takeSnapshot();
                originalNoteTitle = App.tfEventNoteTitle.getValue();
                originalNoteText = App.tfEventNote.getValue();

            }
        });

        if (typeof (rec.raw.item_type) !== "undefined") {
            var itm_type = rec.raw.item_type.toLowerCase();
            switch (itm_type) {

                case 'evt_event':

                    //enable/disable the editing of the event based on closed status
              //      if (rec.raw.status != 2) {
                //        App.btnTreeEvents.enable();
                  //  }
                //    else {
                  //      App.btnTreeEvents.disable();
                  //  }

                    fnDisplayView(VIEW.SCHEDULE.nEVENT);
                    break;

                case 'evt_instrument':
                    if (typeof (rec.raw.mid) !== "undefined") {
                        currMID = rec.raw.mid;
                        currIntakeID = rec.raw.intake_id;
                        currStatus = rec.raw.status;
                        currEventModuleID = rec.raw.pw_event_module_id;

                        //scroll the questionnaire container to the top
                        scrollTopInstrumentForm();
                        
                        if (rec.raw.status == 0) {
                            fnDisplayView(VIEW.SCHEDULE.nNEW_INSTRUMENT);

                            //cach values for save
                            App.direct.INSTRUMENTS.UpdateInstrumentFields(rec.raw.intake_id,
                                                                            rec.raw.pat_pw_id,
                                                                            rec.raw.pat_pw_event_id,
                                                                            rec.raw.pw_event_module_id, {
                                                                                success: function () {
                                                                                    fnLoadInstrument(rec.raw.mid, rec.raw.intake_id, rec.raw.patient_id, rec.raw.pw_event_module_id, false);
                                                                                }
                                                                            });
                        }
                            //instrument is complete so show the report
                        else if (rec.raw.status == 1) {
                            fnDisplayView(VIEW.SCHEDULE.nMODIFIED_INSTRUMENT);

                            //cach values for save
                            App.direct.INSTRUMENTS.UpdateInstrumentFields(rec.raw.intake_id,
                                                                            rec.raw.pat_pw_id,
                                                                            rec.raw.pat_pw_event_id,
                                                                            rec.raw.pw_event_module_id, {
                                                                                success: function () {
                                                                                    fnLoadInstrument(rec.raw.mid, rec.raw.intake_id, rec.raw.patient_id, rec.raw.pw_event_module_id, true);
                                                                                }
                                                                            });


                            //App.pnlInstrumentFormContainer.show();
                            //App.pnlInstrumentFormContainer.tab.show();
                            //App.pnlInstrumentEdit.show();
                            //App.pnlInstrumentReport.show();

                            //App.tpPatientSummary.setActiveTab(App.pnlInstruments);


                        }
                            //instrument is locked so show the report
                        else if (rec.raw.status == 2) {
                            fnDisplayView(VIEW.SCHEDULE.nLOCK_COMPLETED);

                            //cach values for save
                            App.direct.INSTRUMENTS.UpdateInstrumentFields(rec.raw.intake_id,
                                                                            rec.raw.pat_pw_id,
                                                                            rec.raw.pat_pw_event_id,
                                                                            rec.raw.pw_event_module_id, {
                                                                                success: function () {
                                                                                    fnLoadInstrument(rec.raw.mid, rec.raw.intake_id, rec.raw.patient_id, rec.raw.pw_event_module_id, true);
                                                                                }
                                                                            });
                        }
                    }

                    break;

                case 'evt_closed':

                    
                    if (typeof (rec.raw.mid) !== "undefined") {
                        currMID = rec.raw.mid;
                        currIntakeID = rec.raw.intake_id;
                        currStatus = rec.raw.status;
                        currEventModuleID = rec.raw.pw_event_module_id;

                        if (rec.raw.status == 0) {
                            fnDisplayView(VIEW.SCHEDULE.nLOCK_INCOMPLETED);

                            /*catch values for save*/
                            App.direct.INSTRUMENTS.UpdateInstrumentFields(rec.raw.intake_id,
                                                                            rec.raw.pat_pw_id,
                                                                            rec.raw.pat_pw_event_id,
                                                                            rec.raw.pw_event_module_id, {
                                                                                success: function () {
                                                                                    fnLoadInstrument(rec.raw.mid, rec.raw.intake_id, rec.raw.patient_id, rec.raw.pw_event_module_id, false);
                                                                                }
                                                                            });
                        }
                    }
                    break;
            }
        }
        return true;
    };

    var fnLoadInstrument = function (mid, intake_id, patient_id, pw_event_module_id, loadReport) {
        //if we have a mid load the instrument
        if (typeof (mid) !== "undefined") {
            App.direct.PATSUMMARY.LoadInstrument(mid, intake_id, pw_event_module_id, bInstrumentReadOnly, {
                success: function (result) {
                    //load instrument
                    qSetOptionsObj(result);
                    fnSelectedInstrument(bInstrumentReadOnly);
                    question.init({
                        success: function () {
                            setTimeout(function () {
                                /*take snapshot so later we can compare and see if something changed*/
                                arrOriginalResponses = fnInstrumentSnapshot();
                            }, 1);
                        }
                    });

                    //load resport
                    if (loadReport) {
                        var filter = 0;
                        if (bInstrumentReadOnly) {
                            filter = 1;
                        }
                        App.direct.PATSUMMARY.ShowInstrumentReport(patient_id, mid, intake_id, filter, {
                            success: function (result) {
                                fnRenderTrendChart(result);
                                App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentReportContainer);
                            }
                        });
                    }
                    else {
                        fnRenderTrendChart(result);
                    }
                }
            });
        }
    };

    var fnInstrumentCompleted = function (value) {
        value = parseInt(value) || 0;
        var status = ['No', 'Yes'];
        return status[value];
    };

    var fnSelectPathway = function (data, index) {
        if (currPatPWID != data.PAT_PW_ID) {
            nCurrentTreeNodeIndex = -1;
            nCurrentPathwayIndex = index;
            currPatPWID = data.PAT_PW_ID;
            App.direct.PATSUMMARY.OnPathwaySelect(Ext.encode(data), { success: fnDisplayView(VIEW.SCHEDULE.nDEFAULT) });
        }
    };

    var fnRenderPWStatus = function (value) {
        value = parseInt(value) || 0;
        var status = ['', 'Open', 'Closed', 'Cancelled', 'Deleted'];
        return status[value];
    };

    var fnClearTree = function () {
        (App.tTxTree.getRootNode()).removeAll();
    };


    var fnAddEvent = function () {
        bShowAddEvent = true;

        if (App.tpPatientSummary.getActiveTab().id == "pnlMedicalHx" ||
            App.tpPatientSummary.getActiveTab().id == "pnlInstruments") {

            arrNewResponses = fnInstrumentSnapshot();

            if (fnDidInstrumentChange(arrOriginalResponses, arrNewResponses)) {
                return false;
            }
        }

        //var data = arguments[0].record.data;
        //App.direct.PATSUMMARY.OnShowAddEvent(data.PAT_PW_ID);
        App.direct.PATSUMMARY.OnShowEventEdt(0);
    };

    var getSelectedPathways = function () {
        var strPW = '',
            data = (App.gpPathwaysList.getStore()).data.items;
        if (data) {

            $.each(data, function (i, o) {
                if (o.data.SELECTED) {
                    strPW += o.data.PAT_PW_ID + ',';
                }
            });

            if (strPW.length < 1) {
                strPW = 'x,';
            }
        }
        return strPW;
    };

    var fnFilterPWEvents = function () {
        App.direct.PATSUMMARY.RenderCurrentPathwayEvents();
        //var strPW = getSelectedPathways;
        //App.direct.PATSUMMARY.GetFilteredPWEvt(strPW, {
        //    success: function (result) {
        //        var nodes = eval(result);
        //        if (nodes.length > 0) {
        //            App.tTxTree.setRootNode(nodes[0]);
        //        }
        //        else {
        //            (App.tTxTree.getRootNode()).removeAll();
        //        }
        //    }
        //});
    };

    var fnReloadEventsNodes = function (lPatPWEventID) {
        fnFilterPWEvents();
    };

    var fnOnLeftPaneTabChanged = function () {
        var i = (App.tpTxTree.items.findIndex('id', App.tpTxTree.getActiveTab().id)),
            tabs = [App.pnlOutcomes.tab, App.pnlPlan.tab, App.pnlNote.tab, App.pnlMedicalHx.tab],
            selectedRowIndex = 0;
        switch (i) {

            //0 = Instrument Hx tab
            case 0:
                ////hide outcomes, plan and note tabs
                //$.each(tabs, function (i, t) {
                //    if (typeof (t) !== "undefined") {
                //        t.hide();
                //    }
                //});

                fnDisplayView(VIEW.INSTRUMENT_HX.nDEFAULT);

                /*Clear everything...
                App.gpInstrumentsSummary.getSelectionModel().deselectAll();*/
                /*Or reload the last selection...*/
                if (App.gpInstrumentsSummary.hasSelection()) {
                    selectedRowIndex = App.gpInstrumentsSummary.getSelectionModel().getSelection()[0].index;
                    App.gpInstrumentsSummary.getSelectionModel().deselect(selectedRowIndex);
                    App.gpInstrumentsSummary.getSelectionModel().select(selectedRowIndex);
                }

                break;

                //1 = Schedule tab
            case 1:

                fnDisplayView(VIEW.SCHEDULE.nDEFAULT);

                /*Select first Pathway*/
                if (App.gpPathwaysList2.getSelectionModel().hasSelection() == false) {
                    App.gpPathwaysList2.getSelectionModel().select(0);
                    currPatPWID = App.gpPathwaysList2.getSelectionModel().getSelection()[0].data.PAT_PW_ID;
                }

                /*Clear everything...
                App.tTxTree.getSelectionModel().deselectAll();*/
                /*Or reload current selection...*/
                nCurrentTreeNodeIndex = -1;
                $('div[id="tTxTree"] .x-grid-row-selected').click();

                /*App.direct.PATSUMMARY.InstrumentSelProc(1, 2, {
                    success: function () {
                        App.tTxTree.getSelectionModel().deselectAll();
                    }
                });*/

                break;
        }
    };

    var fnShowInstrumentReport = function (strPatientID, lMID, lIntakeID, lCPA, lPatPWID, lPatPWEvtID, lPWEvtModID) {
        var node = App.tTxTree.getRootNode().findChildBy(function (ele) {
            if (typeof (ele.raw.mid) !== "undefined") {
                if (ele.raw.pw_event_module_id != null) {
                    if (ele.raw.mid == lMID
                        /*&& ele.raw.intake_id == 0*/
                        && ele.raw.pat_pw_event_id == lPatPWEvtID
                        && ele.raw.pw_event_module_id == lPWEvtModID) {
                        return true;
                    }
                }
                else {
                    if (ele.raw.mid == lMID
                        /*&& ele.raw.intake_id == 0*/
                        && ele.raw.pat_pw_event_id == lPatPWEvtID) {
                        return true;
                    }
                }
            }
            return false;
        }, this, true);

        if (node) {
            node.set('iconCls', X.net.RM.getIcon('Tick'));
            node.raw.status = 1;
            node.raw.intake_id = lIntakeID;
            currIntakeID = lIntakeID;

            App.tpPatientSummary.setActiveTab(App.pnlInstruments);
            App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentReportContainer);

            App.pnlInstrumentEdit.show();
            App.pnlInstrumentReport.show();

            var filter = 0;
            App.direct.PATSUMMARY.ShowInstrumentReport(strPatientID, lMID, lIntakeID, filter, { success: fnRenderTrendChart });
            App.pnlInstrumentReportContainer.tab.show();

            //update instrument hx tab
            App.direct.PATSUMMARY.GetAllPatPWEvtModules({ eventMask: { showMask: false } });
        }
    };

    var fnResetInstrument = function (strPatientID, lMID, lIntakeID, lCPA, lPatPWID, lPatPWEvtID, lPWEvtModID) {
        var node = App.tTxTree.getRootNode().findChildBy(function (ele) {
            if (typeof (ele.raw.mid) !== "undefined") {
                if (ele.raw.pw_event_module_id != null) {
                    if (ele.raw.mid == lMID
                        /*&& ele.raw.intake_id == 0*/
                        && ele.raw.pat_pw_event_id == lPatPWEvtID
                        && ele.raw.pw_event_module_id == lPWEvtModID) {
                        return true;
                    }
                }
                else {
                    if (ele.raw.mid == lMID
                        /*&& ele.raw.intake_id == 0*/
                        && ele.raw.pat_pw_event_id == lPatPWEvtID) {
                        return true;
                    }
                }
            }
            return false;
        }, this, true);

        if (node) {
            node.set('iconCls', X.net.RM.getIcon('Page'));
            node.raw.status = 0;
            node.raw.intake_id = lIntakeID;
            currIntakeID = lIntakeID;

            //update instrument hx tab
            App.direct.PATSUMMARY.GetAllPatPWEvtModules({ eventMask: { showMask: false } });
        }
    };

    var fnShowInstrumentRptSummary = function (strPatientID, lMID, lIntakeID) {
        var filter = 1;

        fnDisplayView(VIEW.INSTRUMENT_HX.nSUMMARY);

        App.pnlInstrumentReport.show();

        App.direct.PATSUMMARY.ShowInstrumentReport(strPatientID, lMID, lIntakeID, filter, { success: fnRenderTrendChart });

        App.pnlInstrumentContainer.setActiveTab(App.pnlInstrumentReportContainer);

    };

    var fnInitializeTrendTab = function () {
        if (App.pnlInstrumentTrendContainer) {
            $('div[id$="divTrendContainer"]').css({
                'height': App.pnlInstrumentTrendContainer.getHeight() + 'px',
                'width': $('[id$="divResizer"]').width() + 'px'
            });

            var chart = $('div[id$="divTrendContainer"]').highcharts();
            $('#divResizer').each(function () {
                chart.setSize(
                    this.offsetWidth - 20,
                    this.offsetHeight - 20,
                    false
                );
            });
        }
    };

    var fnRenderTrendChart = function (result) {

        if (result != null) {
            if (typeof (result.mid) === "undefined") {
                $('div[id$="divTrendContainer"]').html('<span style="font-weight: bold;">There is no score data available for this instrument.</span>');
            }
            else {

                //render the trend graph
                $('div[id$="divTrendContainer"]').highcharts({
                    title: {
                        text: result.module,
                        x: -20 //center
                    },
                    exporting:
                    {
                        enabled: false
                    },
                    chart: {
                        zoomType: 'x'
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        type: 'datetime',
                        //minTickInterval: 24 * 3600 * 1000,
                        title: {
                            text: 'Date'
                        },
                        dateTimeLabelFormats: {
                            millisecond: '%b %e %H:%M:%S',
                            second: '%b %e %H:%M:%S',
                            minute: '%b %e %H:%M',
                            hour: '%b %e %H:%M',
                            day: '%b %e',
                            week: '%b %e',
                            month: '%b \'%y',
                            year: '%Y'
                        }
                    },
                    yAxis: {
                        title: {
                            text: 'Score'
                        }
                    },
                    legend: {
                        layout: 'vertical',
                        align: 'right',
                        verticalAlign: 'middle',
                        borderWidth: 0
                    },
                    series: result.scores
                });

                // listens to the resizer 
                fnResizeChartListener();


                //----------------------------------
            }
        }
        else {
            $('div[id$="divTrendContainer"]').html('<span style="font-weight: bold;">There is no score data available for this instrument.</span>');
        }
    };

    var fnResizeChartListener = function () {
        var chart = $('div[id$="divTrendContainer"]').highcharts();
        $('#divResizer').resizable({
            // On resize, set the chart size to that of the
            // resizer minus padding. If your chart has a lot of data or other
            // content, the redrawing might be slow. In that case, we recommend
            // that you use the 'stop' event instead of 'resize'.
            resize: function () {
                chart.setSize(
                    this.offsetWidth - 20,
                    this.offsetHeight - 20,
                    false
                );
            }
        });
    };

    //record =  App.tTxTree.getSelectionModel().getSelection()[0]
    function ShowEventCommands(record)
    {
        var bShow = true;

        arrNewResponses = fnInstrumentSnapshot();
        if (fnDidInstrumentChange(arrOriginalResponses, arrNewResponses))
        {
            bShow = false;
        }
        
        App.tTxTree.getSelectionModel().select(record);
        if (bShow) 
        {
            App.direct.PATSUMMARY.OnEditEvent(record.raw.pat_pw_event_id);
        }
    }

    var fnEventCommands = function (a, cmdName, record) {
        var bShow = true;

        arrNewResponses = fnInstrumentSnapshot();

        if (fnDidInstrumentChange(arrOriginalResponses, arrNewResponses)) {
            bShow = false;
        }

        App.tTxTree.getSelectionModel().select(record);

        var cmd = cmdName.toLowerCase();
        switch (cmd) {

            case 'edit':
                if (bShow) {
                    App.direct.PATSUMMARY.OnEditEvent(record.raw.pat_pw_event_id);
                }
                //App.winEditEvent.show();
                break;

        }
    };

    var fnTpPatientSummaryChange = function () {
        if (App.tpPatientSummary.getActiveTab().id == "pnlMedicalHx") {
            if (nCurrentInstrument == 1) {
                nCurrentInstrument = 2;
                /*avoid instrument object to collide*/
                $('[id$="aspPnlInstrumentContainer"]').empty();
                App.direct.UCMEDHX.LoadMedicalHXInstrument({
                    success: function (result) {
                        qSetOptionsObj(result);
                        question.init({
                            success: function () {
                                setTimeout(function () {
                                    /*take snapshot so later we can compare and see if something changed*/
                                    arrOriginalResponses = fnInstrumentSnapshot();
                                }, 1);
                            }
                        });
                    }
                });
            }
        }

        if (App.tpPatientSummary.getActiveTab().id == "pnlInstruments") {
            if (nCurrentInstrument == 2) {
                nCurrentInstrument = 1;
                /*avoid instrument object to collide*/
                $('[id$="aspPnlPastMedicalHx"]').empty();

                if (typeof (currMID) !== "undefined") {

                    App.direct.PATSUMMARY.LoadInstrument(currMID, currIntakeID, currEventModuleID, bInstrumentReadOnly, {
                        success: function (result) {
                            qSetOptionsObj(result);
                            fnSelectedInstrument(bInstrumentReadOnly);
                            question.init({
                                success: function () {
                                    setTimeout(function () {
                                        /*take snapshot so later we can compare and see if something changed*/
                                        arrOriginalResponses = fnInstrumentSnapshot();
                                    }, 1);
                                }
                            });
                        }
                    });
                }
            }
        }

    };

    var fnAfterAddingNewPathway = function () {
        nNewPathwayIndex = 0;
        App.gpPathwaysList2.getSelectionModel().select(nNewPathwayIndex);
        $('div[id="gpPathwaysList2"] .x-grid-row-selected').click();
    };

    var fnCommitNoteToTIU = function () {
        App.direct.PATSUMMARY.CommitEventNote({
            success: function (result) {
                if (result.submitted == true) {
                    App.direct.PATSUMMARY.LoadPatPathwaysList();
                    nCurrentTreeNodeIndex = -1; //index could change, clear tree node index
                    bInstrumentReadOnly = true; //instruments are read-only now
                    if (nCurrentInstrument == 1) {
                        //if current tab is Instrument then set the instrument's controls to read-only
                        fnSelectedInstrument(bInstrumentReadOnly);
                    }
                }
            }
        })
    };

// ----------------------------------------------------------------------------------------
// End Region - Action Events
// ----------------------------------------------------------------------------------------


// ----------------------------------------------------------------------------------------
// Begin Region - Before Change Events
// ----------------------------------------------------------------------------------------

    var fnTpPatientSummaryBeforeChange = function (tabPanel, newCard, oldCard, eOpts) {

        /*leaving the note tab*/
        if (oldCard.id == "pnlNote") {

            if (!App.btnEventNoteSave.disabled) {
                if (originalNoteTitle != App.tfEventNoteTitle.getValue() ||
                    originalNoteText != App.tfEventNote.getValue()) {
                    var cMsg = 'You have unsaved data in the Note tab. Are you sure you want to leave? (Unsaved data will be lost.)';
                    cMsg = cMsg + '\n\nPress OK to continue WITHOUT saving.';
                    cMsg = cMsg + '\nPress Cancel to return to the form to save changes.';

                    if (!confirm(cMsg)) //pressed cancel
                    {
                        //stay where we are to allow user to save
                        return false;
                    }

                    //just press on without saving
                    //
                    //reset the data
                    App.tfEventNoteTitle.setValue(originalNoteTitle);
                    App.tfEventNote.setValue(originalNoteText);

                    return true;
                }
            }            
        }
        
        /*leaving Assessment/Plan tab*/
        if (oldCard.id == "pnlPlan") {
            /*if the current PLAN is different we need to save*/
            if (ucPlanJS.original.planHash != ucPlanJS.takeSnapshot())
            {
                var cMsg = 'You have unsaved data in the Assessment/Plan tab. Are you sure you want to leave? (Unsaved data will be lost.)';
                cMsg = cMsg + '\n\nPress OK to continue WITHOUT saving.';
                cMsg = cMsg + '\nPress Cancel to return to the form to save changes.';

                if (!confirm(cMsg)) //pressed cancel
                {
                    //stay where we are to allow user to save
                    //no autosave!
                    // App.btnUCPlanSave.fireEvent('click');
                    return false;
                }

                //just press on without saving
                //
                //reload original plan
                App.direct.PATSUMMARY.InitPlan(currPWEventID);

                return true;
            }
        }

        //leaving the medical history tab
        if (oldCard.id == "pnlMedicalHx") {
            arrNewResponses = fnInstrumentSnapshot();
            if (fnDidInstrumentChange(arrOriginalResponses, arrNewResponses))
            {
                var cMsg = 'You have unsaved data in the Past Medical History tab. Are you sure you want to leave? (Unsaved data will be lost.)';
                cMsg = cMsg + '\n\nPress OK to continue WITHOUT saving.';
                cMsg = cMsg + '\nPress Cancel to return to the form to save changes.';

                if (!confirm(cMsg)) //pressed cancel
                {
                    //stay where we are to allow user to save
                    return false;
                }

                //just press on without saving
                //
                //reload the hx
                //
                /*avoid instrument object to collide*/
                $('[id$="aspPnlInstrumentContainer"]').empty();
                App.direct.UCMEDHX.LoadMedicalHXInstrument({
                    success: function (result) {
                        qSetOptionsObj(result);
                        question.init({
                            success: function () {
                                setTimeout(function () {
                                /*take snapshot so later we can compare and see if something changed*/
                                arrOriginalResponses = fnInstrumentSnapshot();
                                }, 1);
                            }
                        });
                    }
                });

                return true;
            }
        }

        if ((newCard.id == "pnlMedicalHx" && nCurrentInstrument == 1) ||
            (newCard.id == "pnlInstruments" && nCurrentInstrument == 2)) {

            if (strContinueChange == "continue") {
                strContinueChange = "";
            }
            else {
                if (fnCheckInstrumentChanges(fnHandlerAnswerTabChange)) {
                    /*stop tab change; it will be handler on callback function (fnHandlerAnswerTabChange)*/
                    return false;
                }
            }
        }
    };

    var fnTxTreeBeforeSelect = function (obj, record, index, eOpts) {
        nNewTreeNodeIndex = index;
        if (strContinueChange == "continue") {
            strContinueChange = "";
        }
        else {
            if (fnCheckInstrumentChanges(fnHandlerAnswerNodeChange)) {
                /*stop change; it will be handler on callback function (fnHandlerAnswerNodeChange)*/
                return false;
            }
        }
    }

    var fnSelectPathwayBeforeChange = function (obj, record, item, index, e, eOpts) {
        nNewPathwayIndex = index;
        if (strContinueChange == "continue") {
            strContinueChange = "";
        }
        else {
            if (fnCheckInstrumentChanges(fnHandlerAnswerPathwayChange)) {
                /*stop change; it will be handler on callback function (fnHandlerAnswerPathwayChange)*/
                return false;
            }
        }
    };

// ----------------------------------------------------------------------------------------
// End Region - Before Change Events
// ----------------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------------
// Prompt for Unsaved Changes
// ----------------------------------------------------------------------------------------

    /// check if we need to prompt the user for Save? Yes, No, Cancel
    /// return TRUE if the user was prompt
    ///        FALSE if no need to prompt
    var fnCheckInstrumentChanges = function (handlerAnswer) {
        /*first check if we are in a tab that need this validation*/

        //if (App.tpPatientSummary.getActiveTab().id == "pnlMedicalHx" ||
        //    App.tpPatientSummary.getActiveTab().id == "pnlInstruments") {
        if (nCurrentInstrument == 1 ||
            nCurrentInstrument == 2) {

            arrNewResponses = fnInstrumentSnapshot();

            if (fnDidInstrumentChange(arrOriginalResponses, arrNewResponses)) {

                if (nCurrentInstrument == 1) {
                    msg = "You have unsaved changes in the current Instruments tab (" + strCurrentModuleName + ").";
                }
                else {
                    msg = "You have unsaved changes in the Past Medical History tab.";
                }

                /*prompt async and exit*/
                Ext.MessageBox.show({
                    title: 'Save Changes?',
                    msg: msg + '<br />Would you like to save your changes?',
                    buttons: Ext.MessageBox.YESNOCANCEL,
                    fn: handlerAnswer,
                    icon: Ext.MessageBox.QUESTION,
                    closable: false
                });

                return true;
            }

        }

        /*no need to prompt*/
        return false;

    };


// ----------------------------------------------------------------------------------------
// Begin Region - Handler Prompt Answer
// ----------------------------------------------------------------------------------------
    var fnHandlerAnswerTabChange = function (btn) {
        switch (btn) {
            case "yes":
                if (question.validateQuestionnaire()) {
                    /*save changes and, if successful, go ahead to next tab*/
                    strContinueChange = "continue";
                    if (nCurrentInstrument == 1) {
                        App.direct.INSTRUMENTS.AddInstrumentResponses(
                            App.dfAssessmentDate.getValue(), App.tfAssessmentTime.getValue(),
                            {
                            success: function (result) {
                                fnSuccessAddResponses(result);
                                if (result.saved) {
                                    App.tpPatientSummary.setActiveTab(App.pnlMedicalHx);
                                }
                            },
                            failure: fnFailureAddResponses
                        });
                    }
                    else {
                        App.direct.UCMEDHX.OnMedHxOK({
                            success: function (result) {
                                fnSuccessAddMedicalResponses(result);
                                if (result.saved) {
                                    App.tpPatientSummary.setActiveTab(App.pnlInstruments);
                                }
                            }
                        });
                    }
                }
                else {
                    if (nCurrentInstrument == 1) {
                        App.tpPatientSummary.setActiveTab(App.pnlInstruments);
                    }
                    else {
                        App.tpPatientSummary.setActiveTab(App.pnlMedicalHx);
                    }
                    scrollInstrumentToWarning();
                }
                break;

            case "no":
                /*go ahead to next tab*/
                strContinueChange = "continue";
                if (nCurrentInstrument == 1) {
                    App.tpPatientSummary.setActiveTab(App.pnlMedicalHx);
                }
                else {
                    App.tpPatientSummary.setActiveTab(App.pnlInstruments);
                }
                break;

            case "cancel":
                /*do nothing, process was already cancel in order to present this asynchronous message*/
                break;
        }
    };

    var fnHandlerAnswerNodeChange = function (btn) {
        switch (btn) {
            case "yes":
                strContinueChange = "continue";
                if (question.validateQuestionnaire()) {
                    /*save changes and, if successful, go ahead*/
                    if (nCurrentInstrument == 1) {
                        App.direct.INSTRUMENTS.AddInstrumentResponses(
                            App.dfAssessmentDate.getValue(), App.tfAssessmentTime.getValue(),
                            {
                            success: function (result) {
                                fnSuccessAddResponses(result);
                                if (result.saved) {
                                    fnSelectNewTreeNode();
                                }
                            },
                            failure: fnFailureAddResponses
                        });
                    }
                    else {
                        App.direct.UCMEDHX.OnMedHxOK({
                            success: function (result) {
                                fnSuccessAddMedicalResponses(result);
                                if (result.saved) {
                                    fnSelectNewTreeNode();
                                }
                            }
                        });
                    }
                }
                else {
                    fnSelectCurrentTreeNode();
                    scrollInstrumentToWarning();
                }
                break;

            case "no":
                /*go ahead*/
                strContinueChange = "continue";
                fnSelectNewTreeNode();
                break;

            case "cancel":
                strContinueChange = "continue";
                fnSelectCurrentTreeNode();
                break;
        }
    };

    var fnSelectNewTreeNode = function () {
        App.tTxTree.getSelectionModel().select(nNewTreeNodeIndex);
        $('div[id="tTxTree"] .x-grid-row-selected').click();

        if (App.tTxTree.getSelectionModel().getSelection()[0].raw.is_event) {
            arrOriginalResponses = arrNewResponses;
        }
    };

    /*stay in current Node and highlight it*/
    var fnSelectCurrentTreeNode = function () {
        App.tTxTree.getSelectionModel().select(nCurrentTreeNodeIndex);
    }

    var fnHandlerAnswerPathwayChange = function (btn) {
        switch (btn) {
            case "yes":
                if (question.validateQuestionnaire()) {
                    /*save changes and, if successful, go ahead*/
                    strContinueChange = "continue";
                    if (nCurrentInstrument == 1) {
                        App.direct.INSTRUMENTS.AddInstrumentResponses(
                            App.dfAssessmentDate.getValue(), App.tfAssessmentTime.getValue(),
                            {
                            success: function (result) {
                                fnSuccessAddResponses(result);
                                if (result.saved) {
                                    fnSelectNewPathway();
                                }
                                else {
                                    fnSelectCurrentPathway();
                                }
                            },
                            failure: fnFailureAddResponses
                        });
                    }
                    else {
                        App.direct.UCMEDHX.OnMedHxOK({
                            success: function (result) {
                                fnSuccessAddMedicalResponses(result);
                                if (result.saved) {
                                    fnSelectNewPathway();
                                }
                                else {
                                    fnSelectCurrentPathway();
                                }
                            }
                        });
                    }
                }
                else {
                    scrollInstrumentToWarning(); 
                    fnSelectCurrentPathway();
                }
                break;

            case "no":
                /*go ahead*/
                strContinueChange = "continue";
                fnSelectNewPathway();
                break;

            case "cancel":
                fnSelectCurrentPathway();
                break;
        }
    };

    /*move to new Pathway*/
    var fnSelectNewPathway = function () {
        if (nCurrentInstrument = 2) {
            /*reset default tab*/
            nCurrentInstrument = 1;
            $('[id$="aspPnlPastMedicalHx"]').empty();
        }

        /*move to new Pathway*/
        App.gpPathwaysList2.getSelectionModel().select(nNewPathwayIndex);
        $('div[id="gpPathwaysList2"] .x-grid-row-selected').click();
        if (bShowAddEvent) {
            bShowAddEvent = false;
            App.direct.PATSUMMARY.OnShowEventEdt(0);
        }
    }

    /*stay in current Pathway and highlight it*/
    var fnSelectCurrentPathway = function () {
        App.gpPathwaysList2.getSelectionModel().select(nCurrentPathwayIndex);
    }

// ----------------------------------------------------------------------------------------
// End Region - Handler Prompt Answer
// ----------------------------------------------------------------------------------------



var scrollInstrumentToWarning = function () {
    // scroll the questionnaire container to the first warning msg

    var errTop = $('.validation-err').first().offset().top;

    if (nCurrentInstrument == 1) {
        App.pnlInstrumentEdit.scrollBy(0, errTop - $('div[id="pnlInstrumentEdit"]').offset().top - 10);
    }
    else {
        App.pnlMedInstrument.scrollBy(0, errTop - $('div[id="pnlMedInstrument"]').offset().top - 10);
    }
};